unit uTCPServInst;
//------------------------------------------------------------------------------
//  Last updated:   11/06/03
//  Author:         Dennis Passmore
//  Company:        Ultimate Software, Inc.
//  Contact info:   dennis_passmore@ultimatesoftware.com
//
//  Compatibility:  Delphi for .NET TCP service demo
//
//  Description:    ServiceInstaller for TmpService application
//
//------------------------------------------------------------------------------
interface

uses
  System.ServiceProcess,
  System.Configuration.Install,
  System.ComponentModel, // for RunInstaller
  System.Collections,    // for IDictionary
  Microsoft.Win32;       // for RegistryKey

const
  cNTServiceDesc = 'Delphi for .NET TCP Service Demo';
  cNTServiceDisp = 'Delphi TCP Service';
  cNTServiceProg = 'D4DN_NT_TCPService';

type
  [RunInstaller(True)]
  TNTServiceInstaller = class(System.Configuration.Install.Installer)
  private
    fDepends: array of string;
    fProcessInstaller: System.ServiceProcess.ServiceProcessInstaller;
    fInstaller: System.ServiceProcess.ServiceInstaller;
  strict protected
    procedure OnAfterInstall(savedState: IDictionary); override;
  public
    constructor Create;
  end;

var
  NTServiceInstaller: TNTServiceInstaller = nil;

implementation

constructor TNTServiceInstaller.Create;
begin
  inherited Create;

  SetLength(fDepends, 1);
  fDepends[0] := 'Event Log';

  fProcessInstaller := System.ServiceProcess.ServiceProcessInstaller.Create;
  fProcessInstaller.Account := System.ServiceProcess.ServiceAccount.LocalSystem;

  fInstaller := System.ServiceProcess.ServiceInstaller.Create;
  fInstaller.ServiceName := cNTServiceProg;
  fInstaller.DisplayName := cNTServiceDisp;
  fInstaller.StartType := System.ServiceProcess.ServiceStartMode.Manual;
  fInstaller.ServicesDependedOn := fDepends;

  Installers.Add(fInstaller);
  Installers.Add(fProcessInstaller);
end;

procedure TNTServiceInstaller.OnAfterInstall(savedState: IDictionary);
var
  ServiceKey: RegistryKey;
begin
  ServiceKey := Microsoft.Win32.Registry.LocalMachine.OpenSubKey(
    'SYSTEM\CurrentControlSet\Services\' + cNTServiceProg, True);
  if (ServiceKey <> nil) then
  begin
    ServiceKey.SetValue('Description', cNTServiceDesc );
    ServiceKey.Close;
  end;
end;

end.
